// by Ayumi-Chizuru189
// feel free to use/edit for whatever you want
function Window_ClothRGBSelect() {
  this.initialize.apply(this, arguments);
}

(function() {
"use strict";

  Game_Picture.prototype.tonePixiJS = function() {
    return this._tintPixiJS;
  };

  Game_Picture.prototype.initTonePixiJS = function() {
    this._tintPixiJS = 0xFFFFFF;
  };

  var _Game_Picture_initTone = Game_Picture.prototype.initTone;
  Game_Picture.prototype.initTone = function() {
    this.initTonePixiJS();
    _Game_Picture_initTone.call(this);
  };

  Game_Picture.prototype.tintPixiJS = function(R, G, B) {
    var C = R << 16 | G << 8 | B;
    this._tintPixiJS = C;
  };

  Sprite_Picture.prototype.updateTonePixiJS = function() {
    var picture = this.picture();
    var tint = picture.tonePixiJS();
    if (typeof tint === "number" && tint !== this.tint) {
      this.tint = tint;
      // Ayumi_LDP_OptimiseSprite_Picture compatibility
      var parent = this.parent;
      if (parent) {
        parent.cacheAsBitmap = false;
      }
    }
  };

  var _Sprite_Picture_updateTone = Sprite_Picture.prototype.updateTone;
  Sprite_Picture.prototype.updateTone = function() {
    this.updateTonePixiJS();
    _Sprite_Picture_updateTone.call(this);
  };

  Game_Screen.prototype.tintPicturePixiJS = function(pictureId, R, G, B) {
    var picture = this.picture(pictureId);
    if (picture) {
      picture.tintPixiJS(R, G, B);
    }
  };

  // Below is UI code
  // somewhat messy, written when I was sick
  // a lot of it is copied from !Indivi-SceneOptions.js
  
  Window_ClothRGBSelect.prototype = Object.create(Window_Command.prototype);
  Window_ClothRGBSelect.prototype.constructor = Window_ClothRGBSelect;

  Window_ClothRGBSelect.prototype.makeCommandList = function() {
    this.addCommand("Select Part", "selectPart");
    // this.addCommand("Use tintPicture", "tintPicture");
    // this.addCommand("Use PixiJS Tint", "tintPixiJS");
    this.addCommand("Mode", "tintMode");

    // ToDo: Make these sliders
    this.addCommand("R", "rgb_R");
    this.addCommand("G", "rgb_G");
    this.addCommand("B", "rgb_B");

    this.addCommand("Reset", "reset");
  };

  var commandVal = Object.create(null);
  commandVal.selectPart = 413;
  commandVal.tintMode = "PixiJS 1";
  commandVal.rgb_R = 255;
  commandVal.rgb_G = 255;
  commandVal.rgb_B = 255;

Window_ClothRGBSelect.prototype.drawItem = function(index) {
    var rect = this.itemRectForText(index);
    var statusWidth = this.statusWidth();
    var titleWidth = rect.width - statusWidth;
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
    this.drawText(this.commandName(index), rect.x, rect.y + 18, titleWidth, 'left');
    this.drawText(this.statusText(index), titleWidth, rect.y + 18, statusWidth, 'right');
};

Window_ClothRGBSelect.prototype.statusWidth = function() {
    return 490;
};

Window_ClothRGBSelect.prototype.statusText = function(index) {
    var symbol = this.commandSymbol(index);
    // var value = this.getConfigValue(symbol);
    var value = commandVal[symbol];
    if (this.isRGBSymbol(symbol)) {
        return this.rgbStatusText(value);
    }
    return value;
};

Window_ClothRGBSelect.prototype.isRGBSymbol = function(symbol) {
    return symbol.contains('rgb_');
};

Window_ClothRGBSelect.prototype.rgbStatusText = function(value) {
  var slots = Math.floor((value / 255 * 100) / 5)
  // console.log("test:", slots, value);
  var txt = ""
  for (var i = 1; i <= slots; i++) {
//    txt += "?"
    txt += "||"
  }
  for (var i = 1; i <= 20-slots; i++) {
//    txt += "?"
    txt += "--"
  }
  
  var txt2 = value;
  while (txt2.length < 4) {
    txt2 = " " + txt2
  }
  
  txt += "  " + txt2
  return txt
};

Window_ClothRGBSelect.prototype.windowWidth = function() {
  return 692;
};

Window_ClothRGBSelect.prototype.updatePlacement = function() {
  this.x = 62;
  if (Utils.isMobileDevice()) {
    this.y = 63;
  }
  else {
    this.y = 28;
  }
};

Window_ClothRGBSelect.prototype.windowHeight = function() {
  if (Utils.isMobileDevice()) {
    return 377;
  }
  else {
    return 448;
  }
};

Window_ClothRGBSelect.prototype.processRGBChange = function() {
  var part = commandVal.selectPart;
  if (commandVal.tintMode === "PixiJS 1") {
    $gameScreen.tintPicture(part, [0, 0, 0, 0], 0);
    $gameScreen.tintPicturePixiJS(part, commandVal.rgb_R, commandVal.rgb_G, commandVal.rgb_B);
  } else {
    $gameScreen.tintPicture(part, [commandVal.rgb_R, commandVal.rgb_G, commandVal.rgb_B, 0], 0);
    $gameScreen.tintPicturePixiJS(part, 255, 255, 255);
  }
};

Window_ClothRGBSelect.prototype.processReset = function() {
  commandVal.rgb_R = 255;
  commandVal.rgb_G = 255;
  commandVal.rgb_B = 255;
  commandVal.tintMode = "PixiJS 1";
  this.processRGBChange();
  commandVal.selectPart = 430;
  this.refresh();
};

Window_ClothRGBSelect.prototype.processRGB = function(index, symbol) {
  var rect = this.itemRectForText(index);
  var statusWidth = this.statusWidth();
  var titleWidth = rect.width - statusWidth;
  // var value = this.getConfigValue(symbol);
  var initX = TouchInput.x - titleWidth;
  var clampedX = initX.clamp(12, 430);
  var finalX = Math.round((clampedX - 12) / 418 * 255);
  // console.log("test:", symbol, titleWidth, finalX);
  commandVal[symbol] = finalX;
  this.redrawItem(index);
  this.processRGBChange();
};

Window_ClothRGBSelect.prototype.processOk = function() {
  var index = this.index();
  var symbol = this.commandSymbol(index);
  SoundManager.playOk();
  if (this.isRGBSymbol(symbol)) {
    return this.processRGB(index, symbol);
  }
  var value = commandVal[symbol];
  switch (symbol) {
    case "reset": return this.processReset();
    case "selectPart": commandVal.selectPart = Number(window.prompt("Type a number", "")); break;
    case "tintMode": commandVal[symbol] = value === "PixiJS 1" ? "RPGM-MV 2" : "PixiJS 1";
  }
  this.redrawItem(index);
};

var RGBSelectOpen = false;
var _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
Scene_Map.prototype.createDisplayObjects = function() {
  _Scene_Map_createDisplayObjects.call(this);
  this._clothRGBSelect = new Window_ClothRGBSelect();
  this._clothRGBSelect.visible = false;
  this._clothRGBSelect.active = false;
      RGBSelectOpen = false;
  
  this.addWindow(this._clothRGBSelect);
};

var _Scene_Map_update = Scene_Map.prototype.update;
Scene_Map.prototype.update = function() {
  if (Input.isTriggered('tab') && Utils.isOptionValid('test')) {
    
    if (!this._clothRGBSelect.visible) {
      SoundManager.playOk();
      this._clothRGBSelect.refresh();
      this._clothRGBSelect.visible = true;
      this._clothRGBSelect.active = true;
      RGBSelectOpen = true;
    }
    else {
      SoundManager.playCancel();
      this._clothRGBSelect.visible = false;
      this._clothRGBSelect.active = false;
      RGBSelectOpen = false;
    }
  }
	
	if (this._clothRGBSelect.visible) {
		if (Input.isPressed('cancel') || TouchInput.isCancelled()) {
      SoundManager.playCancel();
      this._clothRGBSelect.visible = false;
      this._clothRGBSelect.active = false;
      RGBSelectOpen = false;
			TouchInput.clear();
			Input.clear();
		}
	}

  _Scene_Map_update.call(this);  
};

var _Game_Player_canMove = Game_Player.prototype.canMove;
Game_Player.prototype.canMove = function() {
  return !(RGBSelectOpen || !_Game_Player_canMove.call(this));
}

// var _Scene_Map_isMenuEnabled = Scene_Map.prototype.isMenuEnabled;
// Scene_Map.prototype.isMenuEnabled = function() {
  // return _Scene_Map_isMenuEnabled.call(this) && !this._clothRGBSelect.visible;
// };

})();

